#include <windows.h>
#include <tchar.h>

#define TSP100_PRINTER_NAME _T("Star TSP100 Cutter (TSP143)")

int main(int argc, char* argv[])
{
	HANDLE			hPrinter;
	DOC_INFO_1		DocInfo;
	DWORD			dwBytesWritten;
	BOOL			res;
	LPCTSTR			TargetPrinterName = TSP100_PRINTER_NAME;

	//------------------------------------------------------
	// Open the printer
	// Need a handle to the printer
	//------------------------------------------------------
	LPTSTR			pPrtName;
	int				len;
	len			  = strlen( TargetPrinterName );
	pPrtName	  = (LPTSTR)calloc( sizeof(BYTE), len + 2 );
	if( ! pPrtName ){
		return 0;
	}
	strcpy( pPrtName, TargetPrinterName );
	res = OpenPrinter( pPrtName, &hPrinter, NULL ) ;
	free( pPrtName );
	if( !res ){
		return 0;
	}

	//------------------------------------------------------
	// Fill in the structure with info about this "document"
	//
	//------------------------------------------------------
	DocInfo.pDocName	= TEXT("WritePrint RAW-Data");
	DocInfo.pOutputFile	= NULL;
	DocInfo.pDatatype	= TEXT("RAW");
	// Inform the spooler the document is beginning.
	if( ( StartDocPrinter( hPrinter, 1, (LPBYTE)&DocInfo ) ) == 0 ){
		ClosePrinter( hPrinter );
		return 0;
	}

	//------------------------------------------------------
	// Start a page
	//
	//------------------------------------------------------
	if( ! StartPagePrinter( hPrinter ) ){
		EndDocPrinter( hPrinter );
		ClosePrinter( hPrinter );
		return 0;
	}

	//------------------------------------------------------
	// Start a page
	// Send the QR code data to the printer
	// Using WritePrinter API
	//------------------------------------------------------

	//	Initialize
	if( ! WritePrinter( hPrinter, "\x1b@", sizeof("\x1b@")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}
	//	Print the title
	if( ! WritePrinter( hPrinter, "TSP100 QR Code Test Print for VC 6.0" "\x0a" "\x0a", sizeof("TSP100 QR Code Test Print for VC 6.0" "\x0a" "\x0a")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}

	///////////////////////////////////////////////////////////
	// QR code sample 1 (DATA: "1234567890")
	if( ! WritePrinter( hPrinter, "DATA: 1234567890" "\x0a", sizeof("DATA: 1234567890" "\x0a")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}

	//	Set QR code type
	//	Set to model 2 ("\x02")
	if( ! WritePrinter( hPrinter, "\x1b\x1d" "yS0" "\x02", sizeof("\x1b\x1d" "yS0" "\x02")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}
	//	Sets mistake correction level to L (Mistake Correction Rate = 15%) ("\x01")
	if( ! WritePrinter( hPrinter, "\x1b\x1d" "yS1" "\x01", sizeof("\x1b\x1d" "yS1" "\x01")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}
	//	Sets cell size to 3 dots("\x03")
	if( ! WritePrinter( hPrinter, "\x1b\x1d" "yS2" "\x03", sizeof("\x1b\x1d" "yS2" "\x03")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}

	//	Set bar code data (Data automatic analysis)
	//	Last 2byte("\x0a\x00") are byte count of QR code data ("1234567890")
	//	10(byte) = 10 + (0 x 256) = "\x0a\x00"
	if( ! WritePrinter( hPrinter, "\x1b\x1d" "yD1" "\x00\x0a\x00", sizeof("\x1b\x1d" "yD1" "\x00\x0a\x00")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}
	if( ! WritePrinter( hPrinter, "1234567890", sizeof("1234567890")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}

	//	Print QR code
	if( ! WritePrinter( hPrinter, "\x1b\x1d" "yP", sizeof("\x1b\x1d" "yP")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}

	///////////////////////////////////////////////////////////
	// QR code sample 2 (DATA: "http://www.star-m.jp/")
	if( ! WritePrinter( hPrinter, "\x0a" "\x0a" "DATA: http://www.star-m.jp/" "\x0a", sizeof("\x0a" "\x0a" "DATA: http://www.star-m.jp/" "\x0a")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}

	//	Set QR code type
	//	Set to model 1 ("\x01")
	if( ! WritePrinter( hPrinter, "\x1b\x1d" "yS0" "\x01", sizeof("\x1b\x1d" "yS0" "\x01")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}
	//	Sets mistake correction level to Q (Mistake Correction Rate = 25%) ("\x02")
	if( ! WritePrinter( hPrinter, "\x1b\x1d" "yS1" "\x02", sizeof("\x1b\x1d" "yS1" "\x02")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}
	//	Sets cell size to 7 dots("\x07")
	if( ! WritePrinter( hPrinter, "\x1b\x1d" "yS2" "\x07", sizeof("\x1b\x1d" "yS2" "\x07")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}

	//	Set bar code data (Data manual analysis)
	//	Last 2byte("\x15\x00") are byte count of QR code data ("http://www.star-m.jp/")
	//	21(byte) = 21 + (0 x 256) = "\x15\x00"
	if( ! WritePrinter( hPrinter, "\x1b\x1d" "yD2" "\x01\x02" "\x15\x00", sizeof("\x1b\x1d" "yD2" "\x01\x02" "\x15\x00")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}
	if( ! WritePrinter( hPrinter, "http://www.star-m.jp/", sizeof("http://www.star-m.jp/")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}

	//	Print QR code
	if( ! WritePrinter( hPrinter, "\x1b\x1d" "yP", sizeof("\x1b\x1d" "yP")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}

	///////////////////////////////////////////////////////////
	// QR code sample 3 (DATA: "STAR MICRONICS CO.,LTD.")
	if( ! WritePrinter( hPrinter, "\x0a" "\x0a" "DATA: STAR MICRONICS CO.,LTD." "\x0a", sizeof("\x0a" "\x0a" "DATA: STAR MICRONICS CO.,LTD." "\x0a")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}

	//	Set QR code type
	//	Set to model 2 ("\x02")
	if( ! WritePrinter( hPrinter, "\x1b\x1d" "yS0" "\x02", sizeof("\x1b\x1d" "yS0" "\x02")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}
	//	Sets mistake correction level to l (Mistake Correction Rate = 7%) ("\x00")
	if( ! WritePrinter( hPrinter, "\x1b\x1d" "yS1" "\x00", sizeof("\x1b\x1d" "yS1" "\x00")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}
	//	Sets cell size to 6 dots("\x06")
	if( ! WritePrinter( hPrinter, "\x1b\x1d" "yS2" "\x06", sizeof("\x1b\x1d" "yS2" "\x06")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}

	//	Set bar code data (Data automatic analysis)
	//	Last 2byte("\x17\x00") are byte count of QR code data ("STAR MICRONICS CO.,LTD.")
	//	  23(byte) = 23 + (0 x 256) = "\x17\x00"
	if( ! WritePrinter( hPrinter, "\x1b\x1d" "yD1" "\x00\x17\x00", sizeof("\x1b\x1d" "yD1" "\x00\x17\x00")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}
	if( ! WritePrinter( hPrinter, "STAR MICRONICS CO.,LTD.", sizeof("STAR MICRONICS CO.,LTD.")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}

	//	Print QR code
	if( ! WritePrinter( hPrinter, "\x1b\x1d" "yP", sizeof("\x1b\x1d" "yP")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}

	//	Partial cut command
	if( ! WritePrinter( hPrinter, "\x1b" "d3", sizeof("\x1b" "d2")-1, &dwBytesWritten ) ){
		EndPagePrinter( hPrinter ); EndDocPrinter( hPrinter ); ClosePrinter( hPrinter ); return 0;
	}

/*
	//------------------------------------------------------
	// End the page
	// Not need
	//------------------------------------------------------
	if( ! EndPagePrinter( hPrinter ) ){
		m_GetErrorMsg();
		EndDocPrinter( hPrinter );
		ClosePrinter( hPrinter );
		return 0;
	}
*/

	//------------------------------------------------------
	// End the document
	// Inform the spooler that the document is ending
	//------------------------------------------------------
	if( ! EndDocPrinter( hPrinter ) ){
		ClosePrinter( hPrinter );
		return 0;
	}

	//------------------------------------------------------
	// Close the printer
	// Tidy up the printer handle
	//------------------------------------------------------
	ClosePrinter( hPrinter );
	return 0;
}
