#include <windows.h>
#include <tchar.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <ctype.h>


// In English  ** SET YOUR PRINTER QUEUE NAME
// In Japanese ** g̃v^ACRɕύXĂB
#define TSP100_PRINTER_NAME       _T("Star TSP100 Cutter (TSP143)")

// Fixed (registry storage destination)
#define TSP100_LM_PATH          _T("SOFTWARE\\StarMicronics\\STLMPLUG\\Star TSP100 Cutter (TSP143)")

// Star Language Monitor dll
#define TSP100_LM_NAME          _T("TSP100LM.DLL")

// Star Language Monitor I/F dll
#define TSP100_IF_NAME          _T("TSP100LMIF.DLL")

// In English:  StarPrinterStatus Structure
// In Japanese: v^̏Ԃi[\
typedef struct StarPrinterStatus_
{
  // printer status 1
  BOOL coverOpen;
  BOOL offline;
  BOOL compulsionSwitch;

  // printer status 2
  BOOL overTemp;
  BOOL unrecoverableError;      // Not support on TSP100
  BOOL cutterError;
  BOOL mechError;               // Not support on TSP100

  // printer status 3
  BOOL pageModeCmdError;        // Not support on TSP100
  BOOL paperSizeError;          // Not support on TSP100
  BOOL presenterPaperJamError;  // Not support on TSP100
  BOOL headUpError;             // Not support on TSP100

  // printer status 4
  BOOL blackMarkDetectStatus;   // Not support on TSP100
  BOOL paperEmpty;
  BOOL paperNearEmptyInner;     // Not support on TSP100
  BOOL paperNearEmptyOuter;     // Not support on TSP100

  // printer status 5
  BOOL stackerFull;             // Not support on TSP100

  // printer status 6
  BOOL etbAvailable;
  BYTE etbCounter;

  // printer status 7
  BYTE presenterState;          // Not support on TSP100

  // raw
  DWORD rawLength;
  BYTE raw[63];
} StarPrinterStatus;

#ifdef UNICODE
#define OpenPort "OpenPort"
typedef HANDLE (WINAPI * OPENPORT)(LPCWSTR, LPCWSTR);
#define GetPrinterSerialNumber "GetPrinterSerialNumberW"
typedef BOOL   (WINAPI * GETPRTSRNO)(LPCWSTR, LPWSTR, DWORD, DWORD *);
#else//!UNICODE
#define OpenPort "OpenPortA"
typedef HANDLE (WINAPI * OPENPORT)(LPCSTR, LPCSTR);
#define GetPrinterSerialNumber "GetPrinterSerialNumberA"
typedef BOOL   (WINAPI * GETPRTSRNO)(LPCSTR, LPSTR, DWORD, DWORD *);
#endif

typedef LONG   (WINAPI * CLOSEPORT)(HANDLE);
typedef LONG   (WINAPI * STATUSCHK)(HANDLE, StarPrinterStatus *);


// Status check function of TSP100
void StatusCheck(HMODULE hTSP100LMDLL)
{
    DWORD               Length   = 0;
    LPBYTE              pBuf     = NULL;
    StarPrinterStatus   status;
    HANDLE              Port;
    wchar_t             raw[256];
    DWORD               i        = 0;
    int                 j        = 0;

    // Call the DLL function
    GETPRTSRNO TSP100_GetPrinterSerialNumber = (GETPRTSRNO)GetProcAddress(hTSP100LMDLL, GetPrinterSerialNumber);
    // Get pritner serial number
    (* TSP100_GetPrinterSerialNumber)(TSP100_PRINTER_NAME, NULL, 0, &Length );
    if(Length == 0)
    {
        wprintf(_T("Not found the printer queue name of \"%s\"\n"), TSP100_PRINTER_NAME);
        return;
    }
    pBuf = (LPBYTE)HeapAlloc(GetProcessHeap(), 0, Length * 2);
    (* TSP100_GetPrinterSerialNumber)(TSP100_PRINTER_NAME, (LPWSTR)pBuf, Length, &Length);

    // Call the DLL function
    OPENPORT TSP100_OpenPort = (OPENPORT)GetProcAddress(hTSP100LMDLL, OpenPort);
    // Open port of TSP100e
    Port = (* TSP100_OpenPort)( (LPCWSTR)pBuf, (LPCWSTR)"");

    HeapFree(GetProcessHeap(), 0, pBuf);

    // Get status of TSP100
    memset(&status, 0, sizeof(StarPrinterStatus));
    STATUSCHK TSP100_StatusCheck = (STATUSCHK) GetProcAddress(hTSP100LMDLL, "GetParsedStatus");
    long rerult = (* TSP100_StatusCheck)( (HANDLE)Port, &status );

    // Out put to the console window
    wprintf(_T("Printer Name: %s\n"), TSP100_PRINTER_NAME);
    // printer status 1
    if(status.coverOpen              != 0) { wprintf(_T("1->coverOpen\n"));             }else{ wprintf(_T("0->coverOpen\n"));               }
    if(status.offline                != 0) { wprintf(_T("1->offline\n"));               }else{ wprintf(_T("0->offline\n"));                 }
    if(status.compulsionSwitch       != 0) { wprintf(_T("1->compulsionSwitch\n"));      }else{ wprintf(_T("0->compulsionSwitch\n"));        }
    // printer status 2
    if(status.overTemp               != 0) { wprintf(_T("1->overTemp\n"));              }else{ wprintf(_T("0->overTemp\n"));                }
    if(status.unrecoverableError     != 0) { wprintf(_T("1->unrecoverableError\n"));    }else{ wprintf(_T("0->unrecoverableError\n"));      }
    if(status.cutterError            != 0) { wprintf(_T("1->cutterError\n"));           }else{ wprintf(_T("0->cutterError\n"));             }
    if(status.mechError              != 0) { wprintf(_T("1->mechError\n"));             }else{ wprintf(_T("0->mechError\n"));               }
    // printer status 3
    if(status.pageModeCmdError       != 0) { wprintf(_T("1->pageModeCmdError\n"));      }else{ wprintf(_T("0->pageModeCmdError\n"));        }
    if(status.paperSizeError         != 0) { wprintf(_T("1->paperSizeError\n"));        }else{ wprintf(_T("0->paperSizeError\n"));          }
    if(status.presenterPaperJamError != 0) { wprintf(_T("1->presenterPaperJamError\n"));}else{ wprintf(_T("0->presenterPaperJamError\n"));  }
    if(status.headUpError            != 0) { wprintf(_T("1->headUpError\n"));           }else{ wprintf(_T("0->headUpError\n"));             }
    // printer status 4
    if(status.blackMarkDetectStatus  != 0) { wprintf(_T("1->blackMarkDetectStatus\n")); }else{ wprintf(_T("0->blackMarkDetectStatus\n"));   }
    if(status.paperEmpty             != 0) { wprintf(_T("1->paperEmpty\n"));            }else{ wprintf(_T("0->paperEmpty\n"));              }
    if(status.paperNearEmptyInner    != 0) { wprintf(_T("1->paperNearEmptyInner\n"));   }else{ wprintf(_T("0->paperNearEmptyInner\n"));     }
    if(status.paperNearEmptyOuter    != 0) { wprintf(_T("1->paperNearEmptyOuter\n"));   }else{ wprintf(_T("0->paperNearEmptyOuter\n"));     }
    // printer status 5
    if(status.stackerFull            != 0) { wprintf(_T("1->stackerFull\n"));           }else{ wprintf(_T("0->stackerFull\n"));             }
    // printer status 6
    if(status.etbAvailable           != 0) { wprintf(_T("1->etbAvailable\n"));          }else{ wprintf(_T("0->etbAvailable\n"));            }
    wprintf(_T("etbCounter     = %d\n"), status.etbCounter);
    // printer status 7
    wprintf(_T("presenterState = %d\n"), status.presenterState);
    // raw
    wprintf(_T("rawLength      = %d\n"), status.rawLength);
    for(i = 0; i < status.rawLength; i++)
    {
        j += swprintf(raw + j, _T("%.2X "), status.raw[i]);
    }
    wprintf(_T("raw            = %s\n"), raw);

    // Call the DLL function
    CLOSEPORT TSP100_ClosePort = (CLOSEPORT)GetProcAddress(hTSP100LMDLL, "ClosePort");
    // Close port of TSP100
    long rerult2 = (* TSP100_ClosePort)((HANDLE)Port);
}

wchar_t *StrToUpper(wchar_t *s)
{
    wchar_t *p;

    for (p = s; *p; p++)
        *p = toupper(*p);
    return (s);
}

int wmain(int argc, wchar_t *argv[ ], wchar_t *envp[ ])
{
    HKEY    hKey;
    DWORD   dwSize;
    BYTE    tsp100lmDllPath[256];
    wchar_t tsp100ifDllPath[256];
    HMODULE hTSP100LMDLL = NULL;

    do{
        // Get the full path of TSP100GTLM.DLL file
        if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, TSP100_LM_PATH, 0, KEY_QUERY_VALUE, &hKey) != ERROR_SUCCESS)
        {
            break;
        }
        if(RegQueryValueEx(hKey, _T("Update"), NULL, NULL, tsp100lmDllPath, &dwSize) != ERROR_SUCCESS)
        {
            if(RegQueryValueEx(hKey, NULL, NULL, NULL, tsp100lmDllPath, &dwSize) != ERROR_SUCCESS)
            {
                break;
            }
        }

        StrToUpper((wchar_t *)tsp100lmDllPath);

        // fullpath :  TSP100100GTLM.DLL --> TSP100GTIF.DLL
        memcpy(&tsp100ifDllPath, &tsp100lmDllPath, 256);
        wchar_t * res = wcsstr( tsp100ifDllPath, TSP100_LM_NAME );
        if(res == NULL)
        {
            break;
        }
        memcpy(res, TSP100_IF_NAME, sizeof(TSP100_IF_NAME));
        
        // Call the TSP100GTIF.DLL file
        hTSP100LMDLL = LoadLibrary((LPCWSTR)tsp100ifDllPath);
        if(hTSP100LMDLL == NULL)
        {
            break;
        }

        int ch;
        // Status check function of TSP100
        StatusCheck(hTSP100LMDLL);
        _cputs("\nPress: \'R\'(Retry) or \'E\'(Exit)\n");
        do{
            ch = _getch();
            ch = toupper(ch);

            if(ch == 'R')
            {
                StatusCheck(hTSP100LMDLL);
                wprintf(_T("\nPress: \'R\'(Retry) or \'E\'(Exit)\n"));
            }
        } while(ch != 'E');

    }while(0);

    if(hTSP100LMDLL) FreeLibrary(hTSP100LMDLL);

    if(hKey) RegCloseKey(hKey);

    return 0;
}
